<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

	class c_partners extends CI_Controller {
		public function __construct()
		{
			parent::__construct();	
			$this->load->model('m_partners');
			
			//upload and update the file
			$config['upload_path'] = 'assets/images/logo/partners';
			$config['allowed_types'] = 'jpeg|jpg|png';
			$config['overwrite'] = true;
			$config['remove_spaces'] = true;
			
			$this->load->library('upload',$config);
		}

	
		function handle_upload()
		{

			$_POST['image'] ='';
		
				if(!$this->upload->do_upload('image'))
				{
					//$ERR = $this->explode_error($this->upload->display_errors());
					$ERR = $this->upload->display_errors();
					$this->form_validation->set_message('handle_upload', $ERR );
					
					return false;
				}
				else
				{				
					// set a $_POST value for 'image' that we can use later
					$upload_data    = $this->upload->data();
					$_POST['image'] = $upload_data['file_name'];
					return true;
				}
							
		}
		
		function handle_upload_edit()
		{

			$_POST['image'] ='';
			
			if ( $_FILES['image']['error'] !== UPLOAD_ERR_NO_FILE )
			{
				if(!$this->upload->do_upload('image'))
				{
					//$ERR = $this->explode_error($this->upload->display_errors());
					$ERR = $this->upload->display_errors();
					$this->form_validation->set_message('handle_upload', $ERR );
					
					return false;
				}
				else
				{				
					// set a $_POST value for 'image' that we can use later
					$upload_data    = $this->upload->data();
					$_POST['image'] = $upload_data['file_name'];
					return true;
				}
			}				
		}
		
		public function index()
		{
			//$data['list'] = $this->m_advertise->showList();
		}
		
		
		
		public function vAdd($err =false)
		{
			$data['error'] = $err;
			$data= array('active'=>'partners',
			);
			$this->template->load('/templates/template','pages/companymenu','pages/partnersadd',$data);
		}
		
		public function vEdit($id,$err = false)
		{
			
			$data= array('active'=>'partners',
						 'detail'=> $this->m_partners->showDetail($id)
			);
			
			$this->template->load('/templates/template','pages/companymenu','pages/partnersedit',$data);
		}
		
		public function add()
		{
			$valid = $this->form_validation;
			$valid->set_rules('name','Name','required|xss_clean');
			$valid->set_rules('image','Image','callback_handle_upload');
			
			if($valid->run())
			{
				
				$data = array(
								'name'=>$this->input->post('name'),
								'image'=>$this->upload->file_name,
								'link'=>$this->input->post('link'),
								'status'=>$this->input->post('status')	
							);
				$this->m_partners->insert($data);
				
				redirect('index.php/partners', 'refresh');
						
			}
			else
			{
				$this->vAdd();
			}
		}
		
		public function edit($id)
		{
			$valid = $this->form_validation;
			$valid->set_rules('name','Name','required|xss_clean');
			$valid->set_rules('image','Image','callback_handle_upload_edit');
			
			if($valid->run())
			{
					if ( $_FILES['image']['error'] !== UPLOAD_ERR_NO_FILE )
					{
						
							
							$data = array(
											'name'=>$this->input->post('name'),
											'image'=>$this->upload->file_name,
											'link'=>$this->input->post('link'),
											'status'=>$this->input->post('status')		
										);
							$this->m_partners->update($id,$data);
							redirect('index.php/partners');
						
					}
					else
					{
						$data = array(
											'name'=>$this->input->post('name'),
											//'advimage'=>$this->upload->file_name,
											'link'=>$this->input->post('link'),
											'status'=>$this->input->post('status')		
										);
							$this->m_partners->update($id,$data);
							redirect('index.php/partners');
					}
			}
			else
			{
				$this->vEdit($id);
			}
		}
	
		
		function delete($id)
		{
			$this->m_partners->delete($id);
			redirect('index.php/partners');
		}
	}
?>