<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

	class c_others extends CI_Controller {
		public function __construct()
		{
			parent::__construct();	
			$this->load->model('m_others');
			$this->load->helper('ckeditor_helper');
			
			//upload and update the file
			$config['upload_path'] = 'assets/images/logo/others';
			$config['allowed_types'] = 'jpeg|jpg|png';
			$config['overwrite'] = true;
			$config['remove_spaces'] = true;
			
			$this->load->library('upload',$config);
		}

		public function ckEditor()
		{
		
		//Ckeditor's configuration
		$ckeditor_content = array(
 
								//ID of the textarea that will be replaced
								'id' 	=> 	'content',
								'path'	=>	'ckeditor',
					 
								//Optionnal values
								'config' => array(
													'toolbar' 	=> 	"Full", 	//Using the Full toolbar
													'width' 	=> 	"655px",	//Setting a custom width
													'height' 	=> 	'200px',	//Setting a custom height
									 
												),
					 
								//Replacing styles from the "Styles tool"
								'styles' => array(
					 
													//Creating a new style named "style 1"
													'style 1' => array (
																			'name' 		=> 	'Blue Title',
																			'element' 	=> 	'h2',
																			'styles' => array(
																								'color' 	=> 	'Blue',
																								'font-weight' 	=> 	'bold'
																							)
																	),
									 
													//Creating a new style named "style 2"
													'style table' => array (
																			'name' 	=> 	'table Header',
																			'element' 	=> 	'table',
																			'styles' => array(
																								'width' 		=> 	'100%',
																								'min-height' => '30px',
																								'float' => 'left',
																								'background-image' 		=> 	'-ms-linear-gradient(bottom, #f6f6f6 0%, #FFFFFF 100%);',
																								'background-image' 		=> '-moz-linear-gradient(bottom, #f6f6f6 0%, #FFFFFF 100%)',
																								'background-image' 		=> '-o-linear-gradient(bottom, #f6f6f6 0%, #FFFFFF 100%)',
																								'background-image'		=> '-webkit-gradient(linear, bottom, bottom, color-stop(0, #f6f6f6), color-stop(1, #FFFFFF))',
																								'background-image' 		=> 'linear-gradient(to bottom right, #f6f6f6 0%, #FFFFFF 100%)',
																							)
																			
																			)				
												)
						);
									
		return $ckeditor_content;
	
		}
	
		function handle_upload()
		{

			$_POST['image'] ='';
		
				if(!$this->upload->do_upload('image'))
				{
					//$ERR = $this->explode_error($this->upload->display_errors());
					$ERR = $this->upload->display_errors();
					$this->form_validation->set_message('handle_upload', $ERR );
					
					return false;
				}
				else
				{				
					// set a $_POST value for 'image' that we can use later
					$upload_data    = $this->upload->data();
					$_POST['image'] = $upload_data['file_name'];
					return true;
				}
							
		}
		
		function handle_upload_edit()
		{

			$_POST['image'] ='';
			
			if ( $_FILES['image']['error'] !== UPLOAD_ERR_NO_FILE )
			{
				if(!$this->upload->do_upload('image'))
				{
					//$ERR = $this->explode_error($this->upload->display_errors());
					$ERR = $this->upload->display_errors();
					$this->form_validation->set_message('handle_upload', $ERR );
					
					return false;
				}
				else
				{				
					// set a $_POST value for 'image' that we can use later
					$upload_data    = $this->upload->data();
					$_POST['image'] = $upload_data['file_name'];
					return true;
				}
			}				
		}
		
		public function index()
		{
			//$data['list'] = $this->m_advertise->showList();
		}
		
		public function vAdd($err =false)
		{
			$data['ckeditor_content'] = $this->ckEditor();
			$data['error'] = $err;
			$data['active'] = 'others';
			
			//$data= array('active'=>'others',
			//);
			$this->template->load('/templates/template','pages/productsmenu','pages/othersadd',$data);
		}
		
		public function vEdit($id,$err = false)
		{
			
			$data= array('active'=>'others',
						 'ckeditor_content'=> $this->ckEditor(),
						 'detail'=> $this->m_others->showDetail($id)
			);
			
			$this->template->load('/templates/template','pages/productsmenu','pages/othersedit',$data);
		}
		
		public function add()
		{
			$valid = $this->form_validation;
			$valid->set_rules('title','Title','required|xss_clean');
			$valid->set_rules('content','Content','required|xss_clean');
			$valid->set_rules('image','Image','callback_handle_upload_edit');
			
			if($valid->run())
			{
				
				$data = array(
								'title'=>$this->input->post('title'),
								'image'=>$this->upload->file_name,
								'content'=>$this->input->post('content'),
								'status'=>$this->input->post('status')	
							);
				$this->m_others->insert($data);
				
				redirect('index.php/others', 'refresh');
						
			}
			else
			{
				$this->vAdd();
			}
		}
		
		public function edit($id)
		{
			$valid = $this->form_validation;
			$valid->set_rules('title','Title','required|xss_clean');
			$valid->set_rules('content','Content','callback_handle_upload_edit');
			
			if($valid->run())
			{
					if ( $_FILES['image']['error'] !== UPLOAD_ERR_NO_FILE )
					{
						
							
							$data = array(
											'title'=>$this->input->post('title'),
											'image'=>$this->upload->file_name,
											'content'=>$this->input->post('content'),
											'status'=>$this->input->post('status')		
										);
							$this->m_others->update($id,$data);
							redirect('index.php/others');
						
					}
					else
					{
						$data = array(
											'title'=>$this->input->post('title'),
											'content'=>$this->input->post('content'),
											'status'=>$this->input->post('status')	
										);
							$this->m_others->update($id,$data);
							redirect('index.php/others');
					}
			}
			else
			{
				$this->vEdit($id);
			}
		}
	
		
		function delete($id)
		{
			$this->m_others->delete($id);
			redirect('index.php/others');
		}
	}
?>