<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

	class c_games extends CI_Controller {
		public function __construct()
		{
			parent::__construct();	
			$this->load->model('m_games');
			
			//upload and update the file
			$config['upload_path'] = 'assets/images/logo/games';
			$config['allowed_types'] = 'jpeg|jpg|png';
			$config['overwrite'] = true;
			$config['remove_spaces'] = true;
			
			$this->load->library('upload',$config);
		}

	
		function handle_upload()
		{

			$_POST['image'] ='';
		
				if(!$this->upload->do_upload('image'))
				{
					//$ERR = $this->explode_error($this->upload->display_errors());
					$ERR = $this->upload->display_errors();
					$this->form_validation->set_message('handle_upload', $ERR );
					
					return false;
				}
				else
				{				
					// set a $_POST value for 'image' that we can use later
					$upload_data    = $this->upload->data();
					$_POST['image'] = $upload_data['file_name'];
					return true;
				}
							
		}
		
		function handle_upload_edit()
		{

			$_POST['image'] ='';
			
			if ( $_FILES['image']['error'] !== UPLOAD_ERR_NO_FILE )
			{
				if(!$this->upload->do_upload('image'))
				{
					//$ERR = $this->explode_error($this->upload->display_errors());
					$ERR = $this->upload->display_errors();
					$this->form_validation->set_message('handle_upload', $ERR );
					
					return false;
				}
				else
				{				
					// set a $_POST value for 'image' that we can use later
					$upload_data    = $this->upload->data();
					$_POST['image'] = $upload_data['file_name'];
					return true;
				}
			}				
		}
		
		public function index()
		{
			//$data['list'] = $this->m_advertise->showList();
		}
		
		
		
		public function vAdd($err =false)
		{
			$data['error'] = $err;
			$data= array('active'=>'games',
			);
			$this->template->load('/templates/template','pages/productsmenu','pages/vouchergamesadd',$data);
		}
		
		public function vEdit($id,$err = false)
		{
			
			$data= array('active'=>'games',
						 'detail'=> $this->m_games->showDetail($id)
			);
			
			$this->template->load('/templates/template','pages/productsmenu','pages/vouchergamesedit',$data);
		}
		
		public function add()
		{
			$valid = $this->form_validation;
			$valid->set_rules('name','Name','required|xss_clean');
			$valid->set_rules('image','Image','callback_handle_upload');
			
			if($valid->run())
			{
				
				$data = array(
								'name'=>$this->input->post('name'),
								'image'=>$this->upload->file_name,
								'link'=>$this->input->post('link'),
								'status'=>$this->input->post('status')	
							);
				$this->m_games->insert($data);
				
				redirect('index.php/vouchergames', 'refresh');
						
			}
			else
			{
				$this->vAdd();
			}
		}
		
		public function edit($id)
		{
			$valid = $this->form_validation;
			$valid->set_rules('name','Name','required|xss_clean');
			$valid->set_rules('image','Image','callback_handle_upload_edit');
			
			if($valid->run())
			{
					if ( $_FILES['image']['error'] !== UPLOAD_ERR_NO_FILE )
					{
						
							
							$data = array(
											'name'=>$this->input->post('name'),
											'image'=>$this->upload->file_name,
											'link'=>$this->input->post('link'),
											'status'=>$this->input->post('status')		
										);
							$this->m_games->update($id,$data);
							redirect('index.php/vouchergames');
						
					}
					else
					{
						$data = array(
											'name'=>$this->input->post('name'),
											//'advimage'=>$this->upload->file_name,
											'link'=>$this->input->post('link'),
											'status'=>$this->input->post('status')		
										);
							$this->m_games->update($id,$data);
							redirect('index.php/vouchergames');
					}
			}
			else
			{
				$this->vEdit($id);
			}
		}
	
		
		function delete($id)
		{
			$this->m_games->delete($id);
			redirect('index.php/vouchergames');
		}
	}
?>