/*
 * Decompiled with CFR 0.152.
 */
package izone.calendar;

import com.toedter.calendar.JDayChooser;
import com.toedter.calendar.JMonthChooser;
import com.toedter.calendar.JYearChooser;
import izone.components.UTF8ResourceBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JCalendar
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 8913369762644440133L;
    private Calendar calendar;
    private boolean initialized = false;
    private final JPanel monthYearPanel;
    private final JPanel specialButtonPanel;
    private boolean isTodayButtonVisible;
    private boolean isNullDateButtonVisible;
    private final String defaultTodayButtonText = "Today";
    private final String defaultNullDateButtonText = "No Date";
    private String todayButtonText;
    private String nullDateButtonText;
    protected JDayChooser dayChooser;
    protected boolean weekOfYearVisible = true;
    protected Locale locale;
    protected JMonthChooser monthChooser;
    protected JYearChooser yearChooser;
    private final JButton todayButton;
    private final JButton nullDateButton;

    public JCalendar() {
        this(null, null, true, true);
    }

    public JCalendar(Date date) {
        this(date, null, true, true);
    }

    public JCalendar(Calendar calendar) {
        this(null, null, true, true);
        this.setCalendar(calendar);
    }

    public JCalendar(Locale locale) {
        this(null, locale, true, true);
    }

    public JCalendar(Date date, Locale locale) {
        this(date, locale, true, true);
    }

    public JCalendar(Date date, boolean monthSpinner) {
        this(date, null, monthSpinner, true);
    }

    public JCalendar(Locale locale, boolean monthSpinner) {
        this(null, locale, monthSpinner, true);
    }

    public JCalendar(boolean monthSpinner) {
        this(null, null, monthSpinner, true);
    }

    public JCalendar(Date date, Locale locale, boolean monthSpinner, boolean weekOfYearVisible) {
        this.setName("JCalendar");
        this.dayChooser = null;
        this.monthChooser = null;
        this.yearChooser = null;
        this.weekOfYearVisible = weekOfYearVisible;
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.calendar = Calendar.getInstance(this.locale);
        this.setLayout(new BorderLayout());
        this.monthYearPanel = new JPanel();
        this.monthYearPanel.setLayout(new BorderLayout());
        this.monthChooser = new JMonthChooser(monthSpinner);
        this.yearChooser = new JYearChooser();
        this.monthChooser.setYearChooser(this.yearChooser);
        this.monthChooser.setLocale(this.locale);
        this.monthYearPanel.add((Component)this.monthChooser, "West");
        this.monthYearPanel.add((Component)this.yearChooser, "Center");
        this.monthYearPanel.setBorder(BorderFactory.createEmptyBorder());
        this.dayChooser = new JDayChooser(weekOfYearVisible);
        this.dayChooser.addPropertyChangeListener((PropertyChangeListener)this);
        this.dayChooser.setLocale(this.locale);
        this.monthChooser.setDayChooser(this.dayChooser);
        this.monthChooser.addPropertyChangeListener((PropertyChangeListener)this);
        this.yearChooser.setDayChooser(this.dayChooser);
        this.yearChooser.addPropertyChangeListener((PropertyChangeListener)this);
        this.add((Component)this.monthYearPanel, "North");
        this.add((Component)this.dayChooser, "Center");
        this.specialButtonPanel = new JPanel();
        this.todayButton = new JButton();
        this.todayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCalendar.this.setDate(new Date());
            }
        });
        this.nullDateButton = new JButton();
        this.nullDateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCalendar.this.dayChooser.firePropertyChange("day", 0, -1);
            }
        });
        this.specialButtonPanel.setVisible(false);
        this.add((Component)this.specialButtonPanel, "South");
        if (date != null) {
            this.calendar.setTime(date);
        }
        this.initialized = true;
        this.setCalendar(this.calendar);
    }

    public static void main(String[] s) {
        JFrame frame = new JFrame("JCalendar");
        JCalendar jcalendar = new JCalendar();
        frame.getContentPane().add(jcalendar);
        frame.pack();
        frame.setVisible(true);
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public JDayChooser getDayChooser() {
        return this.dayChooser;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public JMonthChooser getMonthChooser() {
        return this.monthChooser;
    }

    public JYearChooser getYearChooser() {
        return this.yearChooser;
    }

    public boolean isWeekOfYearVisible() {
        return this.dayChooser.isWeekOfYearVisible();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.calendar != null) {
            Calendar c = (Calendar)this.calendar.clone();
            if (evt.getPropertyName().equals("day")) {
                c.set(5, (Integer)evt.getNewValue());
                this.setCalendar(c, false);
            } else if (evt.getPropertyName().equals("month")) {
                c.set(2, (Integer)evt.getNewValue());
                this.setCalendar(c, false);
            } else if (evt.getPropertyName().equals("year")) {
                c.set(1, (Integer)evt.getNewValue());
                this.setCalendar(c, false);
            } else if (evt.getPropertyName().equals("date")) {
                c.setTime((Date)evt.getNewValue());
                this.setCalendar(c, true);
            }
        }
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.dayChooser != null) {
            this.dayChooser.setBackground(bg);
        }
    }

    public void setCalendar(Calendar c) {
        this.setCalendar(c, true);
    }

    private void setCalendar(Calendar c, boolean update) {
        if (c == null) {
            this.setDate(null);
        }
        Calendar oldCalendar = this.calendar;
        this.calendar = c;
        if (update) {
            this.yearChooser.setYear(c.get(1));
            this.monthChooser.setMonth(c.get(2));
            this.dayChooser.setDay(c.get(5));
        }
        this.firePropertyChange("calendar", oldCalendar, this.calendar);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.dayChooser != null) {
            this.dayChooser.setEnabled(enabled);
            this.monthChooser.setEnabled(enabled);
            this.yearChooser.setEnabled(enabled);
        }
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.dayChooser != null) {
            this.dayChooser.setFont(font);
            this.monthChooser.setFont(font);
            this.yearChooser.setFont(font);
        }
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.dayChooser != null) {
            this.dayChooser.setForeground(fg);
            this.monthChooser.setForeground(fg);
            this.yearChooser.setForeground(fg);
        }
    }

    public void setLocale(Locale l) {
        if (!this.initialized) {
            super.setLocale(l);
        } else {
            Locale oldLocale = this.locale;
            this.locale = l;
            this.dayChooser.setLocale(this.locale);
            this.monthChooser.setLocale(this.locale);
            this.relayoutSpecialButtonPanel();
            this.firePropertyChange("locale", oldLocale, this.locale);
        }
    }

    public void setWeekOfYearVisible(boolean weekOfYearVisible) {
        this.dayChooser.setWeekOfYearVisible(weekOfYearVisible);
        this.setLocale(this.locale);
    }

    public boolean isDecorationBackgroundVisible() {
        return this.dayChooser.isDecorationBackgroundVisible();
    }

    public void setDecorationBackgroundVisible(boolean decorationBackgroundVisible) {
        this.dayChooser.setDecorationBackgroundVisible(decorationBackgroundVisible);
        this.setLocale(this.locale);
    }

    public boolean isDecorationBordersVisible() {
        return this.dayChooser.isDecorationBordersVisible();
    }

    public void setDecorationBordersVisible(boolean decorationBordersVisible) {
        this.dayChooser.setDecorationBordersVisible(decorationBordersVisible);
        this.setLocale(this.locale);
    }

    public Color getDecorationBackgroundColor() {
        return this.dayChooser.getDecorationBackgroundColor();
    }

    public void setDecorationBackgroundColor(Color decorationBackgroundColor) {
        this.dayChooser.setDecorationBackgroundColor(decorationBackgroundColor);
    }

    public Color getSundayForeground() {
        return this.dayChooser.getSundayForeground();
    }

    public Color getWeekdayForeground() {
        return this.dayChooser.getWeekdayForeground();
    }

    public void setSundayForeground(Color sundayForeground) {
        this.dayChooser.setSundayForeground(sundayForeground);
    }

    public void setWeekdayForeground(Color weekdayForeground) {
        this.dayChooser.setWeekdayForeground(weekdayForeground);
    }

    public Date getDate() {
        return new Date(this.calendar.getTimeInMillis());
    }

    public void setDate(Date date) {
        Date oldDate = this.calendar.getTime();
        this.calendar.setTime(date);
        int year = this.calendar.get(1);
        int month = this.calendar.get(2);
        int day = this.calendar.get(5);
        this.yearChooser.setYear(year);
        this.monthChooser.setMonth(month);
        this.dayChooser.setCalendar(this.calendar);
        this.dayChooser.setDay(day);
        this.firePropertyChange("date", oldDate, date);
    }

    public void setSelectableDateRange(Date min, Date max) {
        this.dayChooser.setSelectableDateRange(min, max);
    }

    public Date getMaxSelectableDate() {
        return this.dayChooser.getMaxSelectableDate();
    }

    public Date getMinSelectableDate() {
        return this.dayChooser.getMinSelectableDate();
    }

    public void setMaxSelectableDate(Date max) {
        this.dayChooser.setMaxSelectableDate(max);
    }

    public void setMinSelectableDate(Date min) {
        this.dayChooser.setMinSelectableDate(min);
    }

    public int getMaxDayCharacters() {
        return this.dayChooser.getMaxDayCharacters();
    }

    public void setMaxDayCharacters(int maxDayCharacters) {
        this.dayChooser.setMaxDayCharacters(maxDayCharacters);
    }

    public void setTodayButtonVisible(boolean isTodayButtonVisible) {
        this.isTodayButtonVisible = isTodayButtonVisible;
        this.relayoutSpecialButtonPanel();
    }

    public boolean isTodayButtonVisible() {
        return this.isTodayButtonVisible;
    }

    public void setNullDateButtonVisible(boolean isNullDateButtonVisible) {
        this.isNullDateButtonVisible = isNullDateButtonVisible;
        this.relayoutSpecialButtonPanel();
    }

    public boolean isNullDateButtonVisible() {
        return this.isNullDateButtonVisible;
    }

    private void relayoutSpecialButtonPanel() {
        String text;
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = UTF8ResourceBundle.getBundle("com.toedter.calendar.jcalendar", this.locale);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        this.specialButtonPanel.removeAll();
        int buttonCount = 0;
        if (this.isTodayButtonVisible) {
            text = this.todayButtonText;
            if (text == null && resourceBundle != null) {
                try {
                    text = resourceBundle.getString("todayButton.text");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (text == null) {
                text = "Today";
            }
            this.todayButton.setText(text);
            this.specialButtonPanel.add(this.todayButton);
            ++buttonCount;
        }
        if (this.isNullDateButtonVisible) {
            text = this.nullDateButtonText;
            if (text == null && resourceBundle != null) {
                try {
                    text = resourceBundle.getString("nullDateButton.text");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (text == null) {
                text = "No Date";
            }
            this.nullDateButton.setText(text);
            this.specialButtonPanel.add(this.nullDateButton);
            ++buttonCount;
        }
        this.specialButtonPanel.setLayout(new GridLayout(1, buttonCount));
        if (this.isTodayButtonVisible) {
            this.specialButtonPanel.add(this.todayButton);
        }
        if (this.isNullDateButtonVisible) {
            this.specialButtonPanel.add(this.nullDateButton);
        }
        this.specialButtonPanel.setVisible(this.isNullDateButtonVisible || this.isTodayButtonVisible);
        this.todayButton.invalidate();
        this.todayButton.repaint();
        this.nullDateButton.invalidate();
        this.nullDateButton.repaint();
        this.specialButtonPanel.invalidate();
        this.specialButtonPanel.doLayout();
        this.specialButtonPanel.repaint();
        this.invalidate();
        this.repaint();
    }

    public String getTodayButtonText() {
        return this.todayButtonText;
    }

    public void setTodayButtonText(String todayButtonText) {
        this.todayButtonText = todayButtonText != null & todayButtonText.trim().length() == 0 ? null : todayButtonText;
        this.relayoutSpecialButtonPanel();
    }

    public String getNullDateButtonText() {
        return this.nullDateButtonText;
    }

    public void setNullDateButtonText(String nullDateButtonText) {
        this.nullDateButtonText = nullDateButtonText != null & nullDateButtonText.trim().length() == 0 ? null : nullDateButtonText;
        this.relayoutSpecialButtonPanel();
    }
}

