package izone.dao;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;



public class DataConnection {
	private String url="";
	private String DRIVER="";
	private Connection conn = null;
	private Statement stmt=null;
	private ResultSet rset= null;
	
	public DataConnection()  {
					 
		 url="jdbc:sqlite:src/izone/db/izonedb.db";
		 DRIVER="org.sqlite.JDBC";
		 
	}
	
	public void connect(){

	 try {
		   Class.forName(DRIVER);
		   conn = DriverManager.getConnection(url);
		   
		 } catch (SQLException sqle){
			 System.out.println(sqle);
			 System.exit(0);
		 } catch(ClassNotFoundException cnfe){
			 System.out.println("Class tidak ditemukan.. error:"+cnfe);
			 System.exit(0);
		 }
		
		return;
	}
	
	public void disconnect(){		
		try{	
			
			if(conn!=null){
				conn.close();
				conn=null;
			}
			
			if(rset!=null){
				rset.close();
				conn=null;
			}
			
			if(stmt!=null){
				stmt.close();
				stmt=null;
			}
			
		}catch(SQLException sqle){
			System.out.println("Error Connecting to Database");
			sqle.printStackTrace();
			System.exit(1);
		}
		
		return;
			
	}
	
	public PreparedStatement preparedStatement(String query){
		PreparedStatement stmt=null;
				
		try{
			
			stmt = conn.prepareStatement(query);
			
		}catch(SQLException sqle){
			System.out.println("#"+sqle.getMessage());
		}
		
		return stmt;
	}
	
	public Statement statement(String query){
		Statement stat=null;
			
		try{
			
			stat = conn.createStatement();
			
		}catch(SQLException sqle){
			System.out.println("#"+sqle.getMessage());
		}
		
		return stat;
	}
	
	public ResultSet getResultSet(String query){
		ResultSet rstat=null;
		Statement stat=null;
		try{
			
			stat= conn.createStatement();
			conn.setAutoCommit(false);
			rstat= stat.executeQuery(query);
		//	conn.commit();
			
			
		}catch(SQLException sqle){
			System.out.println("#"+sqle.getMessage()+"error Code :"+sqle.getErrorCode());
		}
		return rstat;
	}
}
