/*
 * Decompiled with CFR 0.152.
 */
package SQLite;

import SQLite.BenchmarkThread;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Benchmark {
    public static int tps = 1;
    public static int nbranches = 1;
    public static int ntellers = 10;
    public static int naccounts = 50000;
    public static int nhistory = 864000;
    public static final int TELLER = 0;
    public static final int BRANCH = 1;
    public static final int ACCOUNT = 2;
    int failed_transactions = 0;
    int transaction_count = 0;
    static int n_clients = 10;
    static int n_txn_per_client = 10;
    long start_time = 0L;
    static boolean transactions = true;
    static boolean prepared_stmt = false;
    static boolean verbose = false;

    public void run(String[] stringArray) {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-clients")) {
                if (i + 1 >= stringArray.length) continue;
                n_clients = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-driver")) {
                if (i + 1 >= stringArray.length) continue;
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-url")) {
                if (i + 1 >= stringArray.length) continue;
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-user")) {
                if (i + 1 >= stringArray.length) continue;
                string3 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-password")) {
                if (i + 1 >= stringArray.length) continue;
                string4 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-tpc")) {
                if (i + 1 >= stringArray.length) continue;
                n_txn_per_client = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-init")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-tps")) {
                if (i + 1 >= stringArray.length) continue;
                tps = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (!stringArray[i].equals("-v")) continue;
            verbose = true;
        }
        if (string.length() == 0 || string2.length() == 0) {
            System.out.println("JDBC based benchmark program\n\nusage:\n\njava SQLite.Benchmark -url [url_to_db] \\\n    [-user [username]] [-password [password]] [-driver [driver_class_name]] \\\n    [-v] [-init] [-tpc N] [-tps N] [-clients N]");
            System.out.println();
            System.out.println("-v          verbose mode");
            System.out.println("-init       initialize the tables");
            System.out.println("-tpc N      transactions per client");
            System.out.println("-tps N      scale factor");
            System.out.println("-clients N  number of simultaneous clients/threads");
            System.out.println();
            System.out.println("Default driver class is SQLite.JDBCDriver");
            System.out.println("in this case use an -url parameter of the form");
            System.out.println("  jdbc:sqlite:/[path]");
            System.exit(1);
        }
        System.out.println("Driver: " + string);
        System.out.println("URL:" + string2);
        System.out.println();
        System.out.println("Scale factor value: " + tps);
        System.out.println("Number of clients: " + n_clients);
        System.out.println("Number of transactions per client: " + n_txn_per_client);
        System.out.println();
        try {
            this.benchmark(string2, string3, string4, bl);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void benchmark(String string, String string2, String string3, boolean bl) {
        Vector<Thread> vector = new Vector<Thread>();
        Thread thread = null;
        Enumeration enumeration = null;
        try {
            int n;
            if (bl) {
                System.out.print("Initializing dataset...");
                this.createDatabase(string, string2, string3);
                System.out.println("done.\n");
            }
            System.out.println("* Starting Benchmark Run *");
            transactions = false;
            prepared_stmt = false;
            this.start_time = System.currentTimeMillis();
            for (n = 0; n < n_clients; ++n) {
                thread = new BenchmarkThread(n_txn_per_client, string, string2, string3, this);
                thread.start();
                vector.addElement(thread);
            }
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                thread = (Thread)enumeration.nextElement();
                thread.join();
            }
            vector.removeAllElements();
            this.reportDone();
            transactions = true;
            prepared_stmt = false;
            this.start_time = System.currentTimeMillis();
            for (n = 0; n < n_clients; ++n) {
                thread = new BenchmarkThread(n_txn_per_client, string, string2, string3, this);
                thread.start();
                vector.addElement(thread);
            }
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                thread = (Thread)enumeration.nextElement();
                thread.join();
            }
            vector.removeAllElements();
            this.reportDone();
            transactions = false;
            prepared_stmt = true;
            this.start_time = System.currentTimeMillis();
            for (n = 0; n < n_clients; ++n) {
                thread = new BenchmarkThread(n_txn_per_client, string, string2, string3, this);
                thread.start();
                vector.addElement(thread);
            }
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                thread = (Thread)enumeration.nextElement();
                thread.join();
            }
            vector.removeAllElements();
            this.reportDone();
            transactions = true;
            prepared_stmt = true;
            this.start_time = System.currentTimeMillis();
            for (n = 0; n < n_clients; ++n) {
                thread = new BenchmarkThread(n_txn_per_client, string, string2, string3, this);
                thread.start();
                vector.addElement(thread);
            }
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                thread = (Thread)enumeration.nextElement();
                thread.join();
            }
            vector.removeAllElements();
            this.reportDone();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
        finally {
            System.exit(0);
        }
    }

    public void reportDone() {
        long l = System.currentTimeMillis();
        double d = ((double)l - (double)this.start_time) / 1000.0;
        System.out.println("\n* Benchmark Report *");
        System.out.print("* Featuring ");
        if (prepared_stmt) {
            System.out.print("<prepared statements> ");
        } else {
            System.out.print("<direct queries> ");
        }
        if (transactions) {
            System.out.print("<transactions> ");
        } else {
            System.out.print("<auto-commit> ");
        }
        System.out.println("\n--------------------");
        System.out.println("Time to execute " + this.transaction_count + " transactions: " + d + " seconds.");
        System.out.println(this.failed_transactions + " / " + this.transaction_count + " failed to complete.");
        double d2 = (double)(this.transaction_count - this.failed_transactions) / d;
        System.out.println("Transaction rate: " + d2 + " txn/sec.");
        this.transaction_count = 0;
        this.failed_transactions = 0;
        System.gc();
    }

    public synchronized void incrementTransactionCount() {
        ++this.transaction_count;
    }

    public synchronized void incrementFailedTransactionCount() {
        ++this.failed_transactions;
    }

    void createDatabase(String string, String string2, String string3) throws Exception {
        Statement statement;
        Object object;
        Object object2;
        Connection connection = this.connect(string, string2, string3);
        String string4 = connection.getMetaData().getDatabaseProductName();
        System.out.println("DBMS: " + string4);
        transactions = true;
        if (transactions) {
            try {
                connection.setAutoCommit(false);
                System.out.println("In transaction mode");
            }
            catch (SQLException sQLException) {
                transactions = false;
            }
        }
        try {
            int n = 0;
            object2 = connection.createStatement();
            object = "SELECT count(*) FROM accounts";
            ResultSet resultSet = object2.executeQuery((String)object);
            object2.clearWarnings();
            while (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            if (transactions) {
                connection.commit();
            }
            object2.close();
            if (n == naccounts * tps) {
                System.out.println("Already initialized");
                Benchmark.connectClose(connection);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("Drop old tables if they exist");
        try {
            statement = connection.createStatement();
            object2 = "DROP TABLE history";
            statement.execute((String)object2);
            statement.clearWarnings();
            object2 = "DROP TABLE accounts";
            statement.execute((String)object2);
            statement.clearWarnings();
            object2 = "DROP TABLE tellers";
            statement.execute((String)object2);
            statement.clearWarnings();
            object2 = "DROP TABLE branches";
            statement.execute((String)object2);
            statement.clearWarnings();
            if (transactions) {
                connection.commit();
            }
            statement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("Creates tables");
        try {
            statement = connection.createStatement();
            object2 = "CREATE TABLE branches (";
            object2 = (String)object2 + "Bid INTEGER NOT NULL PRIMARY KEY,";
            object2 = (String)object2 + "Bbalance INTEGER,";
            object2 = (String)object2 + "filler CHAR(88))";
            statement.execute((String)object2);
            statement.clearWarnings();
            object2 = "CREATE TABLE tellers (";
            object2 = (String)object2 + "Tid INTEGER NOT NULL PRIMARY KEY,";
            object2 = (String)object2 + "Bid INTEGER,";
            object2 = (String)object2 + "Tbalance INTEGER,";
            object2 = (String)object2 + "filler CHAR(84))";
            statement.execute((String)object2);
            statement.clearWarnings();
            object2 = "CREATE TABLE accounts (";
            object2 = (String)object2 + "Aid INTEGER NOT NULL PRIMARY KEY,";
            object2 = (String)object2 + "Bid INTEGER,";
            object2 = (String)object2 + "Abalance INTEGER,";
            object2 = (String)object2 + "filler CHAR(84))";
            statement.execute((String)object2);
            statement.clearWarnings();
            object2 = "CREATE TABLE history (";
            object2 = (String)object2 + "Tid INTEGER,";
            object2 = (String)object2 + "Bid INTEGER,";
            object2 = (String)object2 + "Aid INTEGER,";
            object2 = (String)object2 + "delta INTEGER,";
            object2 = (String)object2 + "tstime TIMESTAMP,";
            object2 = (String)object2 + "filler CHAR(22))";
            statement.execute((String)object2);
            statement.clearWarnings();
            if (transactions) {
                connection.commit();
            }
            statement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("Delete elements in table in case DROP didn't work");
        try {
            int n;
            statement = connection.createStatement();
            object2 = "DELETE FROM history";
            statement.execute((String)object2);
            statement.clearWarnings();
            object2 = "DELETE FROM accounts";
            statement.execute((String)object2);
            statement.clearWarnings();
            object2 = "DELETE FROM tellers";
            statement.execute((String)object2);
            statement.clearWarnings();
            object2 = "DELETE FROM branches";
            statement.execute((String)object2);
            statement.clearWarnings();
            if (transactions) {
                connection.commit();
            }
            object = null;
            prepared_stmt = true;
            if (prepared_stmt) {
                try {
                    object2 = "INSERT INTO branches(Bid,Bbalance) VALUES (?,0)";
                    object = connection.prepareStatement((String)object2);
                    System.out.println("Using prepared statements");
                }
                catch (SQLException sQLException) {
                    object = null;
                    prepared_stmt = false;
                }
            }
            System.out.println("Insert data in branches table");
            for (n = 0; n < nbranches * tps; ++n) {
                if (prepared_stmt) {
                    object.setInt(1, n);
                    object.executeUpdate();
                    object.clearWarnings();
                } else {
                    object2 = "INSERT INTO branches(Bid,Bbalance) VALUES (" + n + ",0)";
                    statement.executeUpdate((String)object2);
                }
                if (n % 100 != 0 || !transactions) continue;
                connection.commit();
            }
            if (prepared_stmt) {
                object.close();
            }
            if (transactions) {
                connection.commit();
            }
            if (prepared_stmt) {
                object2 = "INSERT INTO tellers(Tid,Bid,Tbalance) VALUES (?,?,0)";
                object = connection.prepareStatement((String)object2);
            }
            System.out.println("Insert data in tellers table");
            for (n = 0; n < ntellers * tps; ++n) {
                if (prepared_stmt) {
                    object.setInt(1, n);
                    object.setInt(2, n / ntellers);
                    object.executeUpdate();
                    object.clearWarnings();
                } else {
                    object2 = "INSERT INTO tellers(Tid,Bid,Tbalance) VALUES (" + n + "," + n / ntellers + ",0)";
                    statement.executeUpdate((String)object2);
                }
                if (n % 100 != 0 || !transactions) continue;
                connection.commit();
            }
            if (prepared_stmt) {
                object.close();
            }
            if (transactions) {
                connection.commit();
            }
            if (prepared_stmt) {
                object2 = "INSERT INTO accounts(Aid,Bid,Abalance) VALUES (?,?,0)";
                object = connection.prepareStatement((String)object2);
            }
            System.out.println("Insert data in accounts table");
            for (n = 0; n < naccounts * tps; ++n) {
                if (prepared_stmt) {
                    object.setInt(1, n);
                    object.setInt(2, n / naccounts);
                    object.executeUpdate();
                    object.clearWarnings();
                } else {
                    object2 = "INSERT INTO accounts(Aid,Bid,Abalance) VALUES (" + n + "," + n / naccounts + ",0)";
                    statement.executeUpdate((String)object2);
                }
                if (n % 10000 == 0 && transactions) {
                    connection.commit();
                }
                if (n <= 0 || n % 10000 != 0) continue;
                System.out.println("\t" + n + "\t records inserted");
            }
            if (prepared_stmt) {
                object.close();
            }
            if (transactions) {
                connection.commit();
            }
            System.out.println("\t" + naccounts * tps + "\t records inserted");
            statement.close();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
        Benchmark.connectClose(connection);
    }

    public static int getRandomInt(int n, int n2) {
        int n3 = 0;
        n3 = (int)(Math.random() * (double)(n2 - n + 1));
        return n3 += n;
    }

    public static int getRandomID(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = naccounts;
        switch (n) {
            case 0: {
                n2 += nbranches;
                n4 = ntellers;
            }
            case 1: {
                if (n == 1) {
                    n4 = nbranches;
                }
                n2 += naccounts;
            }
            case 2: {
                n3 = n2 + n4 - 1;
            }
        }
        return Benchmark.getRandomInt(n2, n3);
    }

    public abstract Connection connect(String var1, String var2, String var3);

    public static void connectClose(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            connection.close();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }
}

